------------------------------------------------------------
-- Search Tool Comments.lua
--
-- Version 1.0
--
-- USE: Does a find operation in the context of all the tools.
--
-- written by Sean Konrad (sean@eyeonline.com)
-- updated : Oct. 27, 2005
-- updated : May. 18, 2007 - no longer case sensitive
------------------------------------------------------------



-- Prompts the user to enter the string they wish to search for
ret = composition:AskUser("Search tool comments", {{"Comment:", "Text", Default = "", Lines = 1}})

if ret == nil then print("Cancelled") return end
-- Get a list of every single tool in the comp
toollist = composition:GetToolList()

-- put the value returned by the 
searchString = string.lower(ret["Comment:"])

-- The script will, at the end of its run, highlight the tool with the comment that was searched for.
-- There are two variables in play to keep track of this.  If it's found one tool, it sets up the toolToHighlight
-- variable.  If it never finds a tool, the boolean value toolfound will be in its default "false" state.  This boolean
-- variable is also used to prevent the toolToHighlight variable from being written several times.
-- It will still print the rest of the tools in question.
toolfound = false

-- This creates a counter for the number of tools.
toolCnt = 0

-- This will be used as a table to index the various tools that will potentially be highlighted by the script.
toolsFound = {}

--This variable will be used to populate a dropdown menu.
toolsFoundNames = {}
for i, tool in pairs(toollist) do

	-- Get the tool's attributes...
	local attrs = tool:GetAttrs()
	
	-- If it has a comments field.
	if tool.Comments then
	
		-- If there are keyframes there will be an entry called "1".  Otherwise that value will be nil.
		if tool.Comments:GetKeyFrames()[1] ~= nil then
			
			-- For every key frame search the tool's comments.
			for j, key in pairs(tool.Comments:GetKeyFrames()) do
				if string.find(string.lower(tool.Comments[key]), searchString) then
				
					-- Let the user know we found it.
					print("Found comment \"".. searchString.."\" on frame "..tostring(key).." of "..attrs.TOOLS_Name)
					
					-- Set toolfound = true so it never does this code again (you don't want to prompt the user with the same tool a dozen times).  
					-- Set up the tool to highlight.
					if toolfound == false then
						toolfound = true
						toolToHighlight = tool
						toolCnt = toolCnt + 1
						toolsFound[toolCnt] = tool
						
						toolsFoundNames[toolCnt] = attrs.TOOLS_Name
					end
					
				end
			end
		else
			-- However, if there are no key frames..
			
			if string.find(string.lower(tool.Comments[TIME_UNDEFINED]), searchString) then
				print("Found comment \"".. searchString.."\" on "..attrs.TOOLS_Name)
				if toolfound == false then
					toolfound = true
					toolToHighlight = tool
				end
				toolCnt = toolCnt+1
				toolsFound[toolCnt] = tool
				toolsFoundNames[toolCnt] = attrs.TOOLS_Name
			end
		end
	end
end

-- if it found a tool..
if toolToHighlight then
	--Highlight it!  That is if there are no other tools found
	if toolCnt == 1 then
		composition:SetActiveTool(toolToHighlight)
	else
		
		ret = composition:AskUser("Multiple tools found", {{"Tools", "Dropdown", Options = toolsFoundNames}})
		composition:SetActiveTool(toolsFound[ret["Tools"]+1])

	end
	
else
	-- Or else print an error
	print("Could not find comment "..searchString)
end
